/*
 * AUTHOR: Gonçalo Morais (gnrm@fct.unl.pt) 
 *
 * Version :: 0.0.07 
 * STATE :: Highly Unstable.
 *
 * NUMDE is a scientific
 * library and pretends to implement the state-of-art of the
 * algorithms related with Differential Equations.  Although this
 * project is mainly written by one person, it received the valuable
 * contribution of several people. See the home page of the project
 * for further details.
 */

/*
 *  This file is part of NUMDE.
 *
 *  NUMDE is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  NUMDE is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with NUMDE.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef __NUMDE_VC_C__
#define __NUMDE_VC_C__


#include "numde.h"



/* a more general form of projection in testing */
double * unstableProjection ( double *vector ,       /* the vector to project */ 
			      unsigned dimension ,   /* the dimension of the overall space */
			      unsigned pdimension ,  /* the dimension of the projection space */ 
			      const double *basis )  /* the coordinates of the vectors in new basis */
{
  double *out = calloc( dimension , sizeof(double)) ;
  double *tmp = calloc( pdimension , sizeof(double)) ;

  unsigned i , j ;

  for ( j = 0 ; j < pdimension ; j++ )
    for ( i = 0 ; i < dimension ; i++ )
      tmp[j] += vector[i] * basis[ j * dimension + i] ; /* the dot product by each vector of new basis */

  for ( i = 0 ; i < dimension ; i++ )
    for ( j = 0 ; j < pdimension ; j++ )
      out[i] += tmp[j] * basis[j * dimension + i] ;

  free(tmp) ;
  return out ;
  
}



/* void unstableEulerAngles (const NDorbit *radius , double *oldvector , double *newvector , NDorbit *out )  */
/* { */
/*   double *xvector , *yvector , *zvector ; */
/*   xvector = calloc( out->dim , sizeof(double)) ; */
/*   yvector = calloc( out->dim , sizeof(double)) ; */
/*   zvector = calloc( out->dim , sizeof(double)) ; */
/*   xvector[0] = 1 ; */
/*   yvector[1] = 1 ;   */
/*   zvector[2] = 1 ; */

/*   double *projection = Projection( vector , out->dim , 2 ); */
/*   Normalization( projection , out->dim ) ; */
/*   Normalization( vector , out->dim ) ; */

/*   /\* the 2 Euler's angles necessary, the optimized idea thanks to Rui Rodrigues (rapr@fct.unl.pt) . *\/ */
/*   double theta = atan2( projection[1] , projection[0] ); */
/*   double phi = atan2( sqrt( pow(vector[0],2) + pow(vector[1],2)) , vector[2] ) ; */

/*   Matrix *R = mat_multiply( mat_rotation ( out->dim , theta , 0 , 1 ) , mat_rotation ( out->dim , phi , 0 , 2 )) ; */
/*   Matrix *tmp0 = mat_alloc ( out->dim , 1 ) ; */
/*   Matrix *tmp1 = mat_alloc ( out->dim , 1 ) ; */

/*   unsigned long i ; */
/*   unsigned j ; */

/*   for ( i = 0 ; i < out->number ; i++ ){ */
/*     for ( j = 0 ; j < out->dim ; j++ ) */
/*       tmp0->mem[j] = radius->mem[i * radius->dim + j] ; */

/*     tmp1 = mat_multiply( R , tmp0 ) ; */

/*     for ( j = 0 ; j < out->dim ; j++ ) */
/*       out->mem[i * out->dim + j] = tmp1->mem[j] ; */
/*   } */

/*   mat_free(R) ; */
/*   mat_free(tmp0) ; */
/*   mat_free(tmp1) ; */
/*   free(xvector) ; */
/*   free(yvector) ; */
/*   free(zvector) ; */

/*   free(projection) ; */
/* } */



void EulerAngles (const NDorbit *radius , double *vector , NDorbit *out ) 
{
  double *xvector , *yvector , *zvector ;
  xvector = calloc( out->dim , sizeof(double)) ;
  yvector = calloc( out->dim , sizeof(double)) ;
  zvector = calloc( out->dim , sizeof(double)) ;
  xvector[0] = 1 ;
  yvector[1] = 1 ;  
  zvector[2] = 1 ;

  double *projection = Projection( vector , out->dim , 2 );
  Normalization( projection , out->dim ) ;
  Normalization( vector , out->dim ) ;

  /* the 2 Euler's angles necessary, the optimized idea thanks to Rui Rodrigues (rapr@fct.unl.pt) . */
  double theta = atan2( projection[1] , projection[0] );
  double phi = atan2( sqrt( pow(vector[0],2) + pow(vector[1],2)) , vector[2] ) ;

  Matrix *R = mat_multiply( mat_rotation ( out->dim , theta , 0 , 1 ) , mat_rotation ( out->dim , phi , 0 , 2 )) ;
  Matrix *tmp0 = mat_alloc ( out->dim , 1 ) ;
  Matrix *tmp1 = mat_alloc ( out->dim , 1 ) ;

  unsigned long i ;
  unsigned j ;

  for ( i = 0 ; i < out->number ; i++ ){
    for ( j = 0 ; j < out->dim ; j++ )
      tmp0->mem[j] = radius->mem[i * radius->dim + j] ;

    tmp1 = mat_multiply( R , tmp0 ) ;

    for ( j = 0 ; j < out->dim ; j++ )
      out->mem[i * out->dim + j] = tmp1->mem[j] ;
  }

  mat_free(R) ;
  mat_free(tmp0) ;
  mat_free(tmp1) ;
  free(xvector) ;
  free(yvector) ;
  free(zvector) ;

  free(projection) ;
}

double Dot ( double *va , double *vb , unsigned dimension ) 
{
  double out = 0 ;

  unsigned i ;
  for ( i = 0 ; i < dimension ; i++ )
    out += va[i] * vb[i] ;

  return out ;
}

void Normalization( double *vector , unsigned dimension )
{
  unsigned i ;
  double norm =  sqrt( Dot( vector , vector , dimension ) ) ;
  
  for ( i = 0 ; i < dimension ; i++ )
    vector[i] = vector[i] / ( norm + 0.0 ) ;

}


double * Projection( double *vector , unsigned dimension , unsigned ortdir )
{
  double *xvec = malloc( dimension * sizeof(double)) ;

  unsigned i ; 
  for ( i = 0 ; i < dimension ; i++ ){
    xvec[i] = 1 ;
  }
  
  for ( i = 0 ; i < dimension ; i++ )
    xvec[i] = vector[i] * xvec[i] ;

  xvec[ortdir] = 0 ;
 
  return xvec ;
}

#endif
