/*
 * AUTHOR: Gonçalo Morais (gnrm@fct.unl.pt) 
 *
 * Version :: 0.0.07 
 * STATE :: Highly Unstable.
 *
 * NUMDE is a scientific
 * library and pretends to implement the state-of-art of the
 * algorithms related with Differential Equations.  Although this
 * project is mainly written by one person, it received the valuable
 * contribution of several people. See the home page of the project
 * for further details.
 */

/*
 *  This file is part of NUMDE.
 *
 *  NUMDE is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  NUMDE is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with NUMDE.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef __NUMDE_PRINT_C__
#define __NUMDE_PRINT_C__


#include "numde.h"


/*****************************************************************************
 *****************************************************************************
 * We need to produce a structured output (print) for the structures
 * defined.
 *****************************************************************************
 ****************************************************************************/

void NDorbit_print ( NDorbit *in )
{
  double *nd ;
  
  unsigned long int rows = in -> number ;
  unsigned int columns = in -> dim ;

  unsigned long int i ;
  unsigned int j ;

  assert ( in != NULL ) ;
  for ( i = 0 ; i < rows ; i++ ){
    nd=NDp(in,i) ;
    printf("\n") ;  
    for ( j = 0 ; j < columns ; j++ ){ 
	printf("%f " , nd[j] ) ;
      }
    }
  
  /* put another line at the end */
  printf("\n") ;
}


/* print for a file */
void NDorbit_fprint ( char *filename , NDorbit *in )
{
  fprintf( stdout , "Opening file %s\n" , filename ) ;
  
  /* Warning: We assume that the file is not already open */
  FILE *outfile ;
  outfile = fopen( filename , "w" ) ;

  
  double *nd ;
  
  unsigned long int rows = in -> number ;
  unsigned int columns = in -> dim ;

  unsigned long int i ;
  unsigned int j ;

  fprintf( stdout , "Writing data into file %s\n" , filename ) ;

  assert ( in != NULL ) ;
  for ( i = 0 ; i < rows ; i++ ){
    nd=NDp(in,i) ;
    fprintf(outfile , "\n") ;  
    for ( j = 0 ; j < columns ; j++ ){ 
      fprintf(outfile, "%f " , nd[j] ) ;
    }
  }
  
  fprintf( stdout , "Closing file %s\n\n" , filename ) ;

  fclose(outfile) ;
}


/* Prints the coordinates of an NDtmesh */
void NDtmeshCoordPrint (NDtmesh *mesh )
{
  assert ( mesh != NULL ) ;

  unsigned long int i ;
  unsigned int j ;

  /* print the coordinate of the points */ 
  for ( i = 0 ; i < mesh->nvert ; i++ ){
    printf("\n") ;  
    for ( j = 0 ; j < mesh->dim ; j++ ){ 
	printf("%f " , mesh->coord[i * mesh->dim + j]  ) ;
      }
    }
  
  /* put another line at the end */
  printf("\n") ;
}

/* prints the triangles combination of the NDtmesh*/
void NDtmeshTriPrint ( NDtmesh *mesh )
{
  assert ( mesh != NULL ) ;

  unsigned int columns = 3 ;
  
  unsigned long int i ;
  unsigned int j ;

  /* print the coordinate of the points */ 
  for ( i = 0 ; i < mesh->ntri ; i++ ){
    printf("\n") ;  
    for ( j = 0 ; j < columns ; j++ ){ 
	printf("%ld " , mesh->tri[i*columns + j]  ) ;
      }
    }
  
  /* put another line at the end */
  printf("\n") ;
}

void NDstmeshCoordPrint ( NDstmesh *mesh )
{
  assert ( mesh != NULL ) ;

  unsigned long int i ;
  unsigned int j ;

  /* print the coordinate of the points */ 
  for ( i = 0 ; i < mesh->nvert ; i++ ){
    printf("\n") ;  
    for ( j = 0 ; j < mesh->dim ; j++ ){ 
	printf("%f " , mesh->coord[i * mesh->dim + j]  ) ;
      }
    }
  
  /* put another line at the end */
  printf("\n") ;
}


#endif
