/*
 * AUTHOR: Gonçalo Morais (gnrm@fct.unl.pt) 
 *
 * Version :: 0.0.07 
 * STATE :: Highly Unstable.
 *
 * NUMDE is a scientific
 * library and pretends to implement the state-of-art of the
 * algorithms related with Differential Equations.  Although this
 * project is mainly written by one person, it received the valuable
 * contribution of several people. See the home page of the project
 * for further details.
 */

/*
 *  This file is part of NUMDE.
 *
 *  NUMDE is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  NUMDE is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with NUMDE.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef _NUMDE_POVRAY_C__
#define _NUMDE_POVRAY_C__

#include "numde.h"
#include "numde_povray.h"

/********************************************************************
 ********************************************************************
 ********************************************************************
 * The next section is the definition of functions used to produce an
 * output for POVRAY
 ********************************************************************
 ********************************************************************
 ********************************************************************/

void NDpovInclude (FILE *out,char *pack){
  fprintf(out,"#include \"%s\"\n",pack);
}

void NDpovAddCamera(FILE *out, TDvector pos, TDvector look, TDvector rot)
{
  assert(out!=NULL);

  fprintf(out,
	  "camera {\n"
	  "location < %f , %f , %f >\n"
	  "look_at < %f , %f , %f >\n"
	  "rotate < %f , %f , %f >\n"
	  "}\n\n",
	  pos.x,pos.y,pos.z,
	  look.x,look.y,look.z,
	  rot.x,rot.y,rot.z);
}


void NDpovAddAreaLS(FILE *out, TDvector dir, Color color)
{
  assert(out!=NULL);

  fprintf(out,
	  "light_source {\n"
	  "<%f, %f, %f >*4\n"
	  "color rgb <%.2f, %.2f, %.2f>\n"
	  "area_light\n"
	  "2*x, 2*z,\n"
	  "4, 4\n"
	  "circular\n"
	  "orient\n"
	  "adaptive 1\n"
	  "jitter}\n\n",
	  dir.x,dir.y,dir.z,color.r,color.g,color.b);
}

void NDpovSphereOrbit (FILE *out, NDorbit *in, double radius , char *texture )
{
  assert(out != NULL && in != NULL);

  unsigned dimension = in->dim ;

  unsigned long int i;
  for(i = 0 ; i < in->number ; i++)
    fprintf(out,
	     "sphere {\n"
	     "<%f, %f, %f >, %f\n"
	     "texture { %s }\n"
	     "finish {\n"
	     "phong .5 }\n"
	    "}\n",	    
	    in->mem[i*dimension] ,
	    in->mem[i*dimension + 1],
	    in->mem[i*dimension + 2],
	    radius , 
	    texture );
}

/* Just add a beautiful sky to our scene. */
void NDpovSky ( FILE *out , double *scale )
{
    fprintf(out,
	  "sky_sphere {\n"
	  "pigment {\n"
	  "gradient <1,1,1>\n"
	  "color_map {\n"
	  "[ 0.0 color rgb <0.99, 0.99, 1> ]\n"
	  "[ 1.0 color rgb <0.1, 0.1, 0.7> ]\n"
	  "}\n"
	  "scale <%f, %f, %f>\n"
	  "}\n"
	    "}\n",
	    scale[0] , scale[1] , scale[2] );
}



void NDpovmesh2 ( FILE *outfile , NDtmesh *mesh )
{

  if ( outfile == NULL || mesh == NULL )
    return ;

  unsigned long i ;
  unsigned triside = 3 ;

  fprintf( outfile , 
	   "mesh2 {\n"
	   "   vertex_vectors {\n"
	   "   %ld,\n",
	   mesh->nvert ) ;
  
  
  for ( i = 0 ; i < mesh->nvert ; i++ ){
    if ( i < mesh->nvert - 1 )
      fprintf( outfile ,
	       "    < %f , %f , %f >,\n",
	       mesh->coord[i * triside ] ,   
	       mesh->coord[i * triside + 1] ,   
	       mesh->coord[i * triside + 2] ) ;
    else 
      fprintf( outfile ,
	       "    < %f , %f , %f >\n",
	       mesh->coord[i * triside ] ,   
	       mesh->coord[i * triside + 1] ,   
	       mesh->coord[i * triside + 2] ) ;
  }

  fprintf( outfile , 
	   " }\n  face_indices {\n"
	   "   %ld,\n",
	   mesh->ntri ) ;

  for ( i = 0 ; i < mesh->ntri ; i++ ){
    if ( i < mesh->ntri - 1 )
      fprintf( outfile ,
	       "    < %ld , %ld , %ld >,\n",
	       mesh->tri[i * triside ] ,   
	       mesh->tri[i * triside + 1] ,   
	       mesh->tri[i * triside + 2] ) ;
    else 
      fprintf( outfile ,
	       "    < %ld , %ld , %ld >\n",
	       mesh->tri[i * triside ] ,   
	       mesh->tri[i * triside + 1] ,   
	       mesh->tri[i * triside + 2] ) ;
  }

  fprintf( outfile ,
	   " }\n"
	   "pigment { color rgb<.7,.3,.9>}\n"
	   "finish { phong .5 phong_size 70 \n"
	   "        diffuse .7\n"
	   "        metallic }\n"
	   "\n}" );

}

/* other textures */
/* {T_Wood1} */
/* texture {T_Wood1 scale 2} */
/* pigment { color rgb<.7,.3,.9>}*/

/* now the function to write down a smooth mesh */
void NDpovsmesh2 ( FILE *outfile , NDstmesh *mesh )
{

  if ( outfile == NULL || mesh == NULL )
    return ;

  unsigned long i ;
  unsigned triside = 3 ;
  
  /* first the coordinates of the vertices */ 
  fprintf( outfile , 
	   "mesh2 {\n"
	   "   vertex_vectors {\n"
	   "   %ld,\n",
	   mesh->nvert ) ;
  
  
  for ( i = 0 ; i < mesh->nvert ; i++ ){
    if ( i < mesh->nvert - 1 )
      fprintf( outfile ,
	       "    < %f , %f , %f >,\n",
	       mesh->coord[i * triside ] ,   
	       mesh->coord[i * triside + 1] ,   
	       mesh->coord[i * triside + 2] ) ;
    else 
      fprintf( outfile ,
	       "    < %f , %f , %f >\n",
	       mesh->coord[i * triside ] ,   
	       mesh->coord[i * triside + 1] ,   
	       mesh->coord[i * triside + 2] ) ;
  }
  
  /* second the coordinates of the normal vectors */
  fprintf( outfile , 
	   " }\n  normal_vectors {\n"
	   "   %ld,\n",
	   mesh->nnvec ) ;
  
  for ( i = 0 ; i < mesh->nnvec ; i++ ){
    if ( i < mesh->nnvec - 1 )
      fprintf( outfile ,
	       "    < %f , %f , %f >,\n",
	       mesh->nvec[i * triside ] ,   
	       mesh->nvec[i * triside + 1] ,   
	       mesh->nvec[i * triside + 2] ) ;
    else 
      fprintf( outfile ,
	       "    < %f , %f , %f >\n",
	       mesh->nvec[i * triside ] ,   
	       mesh->nvec[i * triside + 1] ,   
	       mesh->nvec[i * triside + 2] ) ;
  }
 
  
  /* finnaly the triangles */
  fprintf( outfile , 
	   " }\n  face_indices {\n"
	   "   %ld,\n",
	   mesh->ntri ) ;
  
  for ( i = 0 ; i < mesh->ntri ; i++ ){
    if ( i < mesh->ntri - 1 )
      fprintf( outfile ,
	       "    < %ld , %ld , %ld >,\n",
	       mesh->tri[i * triside ] ,   
	       mesh->tri[i * triside + 1] ,   
	       mesh->tri[i * triside + 2] ) ;
    else 
      fprintf( outfile ,
	       "    < %ld , %ld , %ld >\n",
	       mesh->tri[i * triside ] ,   
	       mesh->tri[i * triside + 1] ,   
	       mesh->tri[i * triside + 2] ) ;
  }
  
  fprintf( outfile ,
	   " }\n"
	   "texture { Aluminum }\n"
	   "finish { phong .5 phong_size 70 \n"
	   "        diffuse .7\n"
	   "        metallic }\n"
	   "\n}" );
  
}

/* "pigment { color rgb<.7,.3,.9>}\n" */

#endif 
