/*
 * AUTHOR: Gonçalo Morais (gnrm@fct.unl.pt) 
 *
 * Version :: 0.0.07 
 * STATE :: Highly Unstable.
 *
 * NUMDE is a scientific
 * library and pretends to implement the state-of-art of the
 * algorithms related with Differential Equations.  Although this
 * project is mainly written by one person, it received the valuable
 * contribution of several people. See the home page of the project
 * for further details.
 */

/*
 *  This file is part of NUMDE.
 *
 *  NUMDE is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  NUMDE is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with NUMDE.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef __NUMDE_MEM_C__
#define __NUMDE_MEM_C__


#include "numde.h"


/*****************************************************************************
 *****************************************************************************
 * The first functions are necessery to alloc and free memory for
 * structure NDorbit.
 *****************************************************************************
 ****************************************************************************/
NDorbit* NDorbit_alloc ( unsigned long int nelements , unsigned int dimension )
{
  NDorbit *out ;

  out = malloc ( sizeof( NDorbit ) ) ;

  if ( out == NULL )
    return NULL ;

  out->dim = dimension ;
  out->number = nelements ;
  out->mem =  calloc( dimension * nelements , sizeof( double ) ) ;

  if ( out -> mem == NULL ) 
    return NULL ;

  return out ;
}

void NDorbit_free ( NDorbit *in ){
  if ( in == NULL ) 
    return ;
  free(in -> mem) ;
  free(in) ;
}


NDtmesh * NDtmesh_alloc ( unsigned long ncirc , unsigned nrad , unsigned dimension )
{ 
  /* 
   * To produce a tubular mesh, we need at least 3 points in each
   * circle and at least 2 circles.
   */
  if ( nrad < 3 || ncirc < 2 ){
    printf("ERROR: It is not possible to produce a tubular mesh with these values.\n") ;
    return ( NULL ) ;
  }
  
  unsigned triside = 3 ; /* the number of sides in a triangle */

  NDtmesh *out ;
  out = malloc ( sizeof ( NDtmesh )) ;
  
  out->dim = dimension ;
  out->rad = nrad ;
  out->circ = ncirc ;
  out->nvert = nrad * ncirc ;
  out->ntri = 2 * nrad * ( ncirc - 1 ) ;

  out->coord = calloc ( dimension * out->nvert , sizeof(double) );
  out->tri   = calloc ( triside * out->ntri , sizeof(unsigned long)) ; 
  
  if ( out == NULL ) 
    return NULL ;

  return out ;
}


NDtmesh * NDctmesh_alloc ( unsigned long ncirc , unsigned nrad , unsigned dimension )
{ 
  /* 
   * To produce a tubular mesh, we need at least 3 points in each
   * circle and at least 2 circles.
   */
  if ( nrad < 3 || ncirc < 2 ){
    printf("ERROR: It is not possible to produce a tubular mesh with these values.\n") ;
    return ( NULL ) ;
  }
  
  unsigned triside = 3 ; /* the number of sides in a triangle */

 NDtmesh *out ;
  out = malloc ( sizeof (NDtmesh )) ;
  
  out->dim = dimension ;
  out->rad = nrad ;
  out->circ = ncirc ;
  out->nvert = nrad * ncirc ;
  out->ntri = 2 * nrad * ncirc ;

  out->coord = calloc ( dimension * out->nvert , sizeof(double) );
  out->tri   = calloc ( triside * out->ntri , sizeof(unsigned long)) ; 
  
  if ( out == NULL ) 
    return NULL ;

  return out ;
}


NDstmesh * NDcstmesh_alloc ( unsigned long ncirc , unsigned nrad , unsigned dimension )
{ 
  /* 
   * To produce a tubular mesh, we need at least 3 points in each
   * circle and at least 2 circles.
   */
  if ( nrad < 3 || ncirc < 2 ){
    printf("ERROR: It is not possible to produce a tubular mesh with these values.\n") ;
    return ( NULL ) ;
  }
  
  unsigned triside = 3 ; /* the number of sides in a triangle */

  NDstmesh *out ;
  out = malloc ( sizeof ( NDstmesh )) ;
  
  out->dim = dimension ;
  out->rad = nrad ;
  out->circ = ncirc ;
  out->nvert = nrad * ncirc ;
  out->ntri = 2 * nrad * ncirc ;
  out->nnvec = out->nvert ;
    
  out->coord = calloc ( dimension * out->nvert , sizeof(double) );
  out->tri   = calloc ( triside * out->ntri , sizeof(unsigned long)) ;
  out->nvec  = calloc ( dimension * out->nnvec , sizeof( double ) ) ;
  
  if ( out == NULL ) 
    return NULL ;

  return out ;
}


NDstmesh * NDstmesh_alloc ( unsigned long ncirc , unsigned nrad , unsigned dimension )
{ 
  /* 
   * To produce a tubular mesh, we need at least 3 points in each
   * circle and at least 2 circles.
   */
  if ( nrad < 3 || ncirc < 2 ){
    printf("ERROR: It is not possible to produce a tubular mesh with these values.\n") ;
    return ( NULL ) ;
  }
  
  unsigned triside = 3 ; /* the number of sides in a triangle */

  NDstmesh *out ;
  out = malloc ( sizeof ( NDstmesh )) ;
  
  out->dim = dimension ;
  out->rad = nrad ;
  out->circ = ncirc ;
  out->nvert = nrad * ncirc ;
  out->ntri = 2 * nrad * ( ncirc - 1 ) ;
  out->nnvec = out->nvert ;
    
  out->coord = calloc ( dimension * out->nvert , sizeof(double) );
  out->tri   = calloc ( triside * out->ntri , sizeof(unsigned long)) ;
  out->nvec  = calloc ( dimension * out->nnvec , sizeof( double ) ) ;
  
  if ( out == NULL ) 
    return NULL ;

  return out ;
}


/* serves perfectly for open and closed mesh's */
void NDtmesh_free (NDtmesh *in )
{
  if ( in == NULL )
    return ;

  free ( in->coord ) ;
  free ( in->tri ) ;
  free ( in ) ;
}

void NDstmesh_free ( NDstmesh *in )
{
  if ( in == NULL )
    return ;

  free ( in->coord ) ;
  free ( in->tri ) ;
  free ( in->nvec ) ;
  free ( in ) ;
}
#endif
