#include <stdio.h>

#include "numde.h"

#define K1 3
#define K2 3


/* the vector field that is used in the computations (see numde.h, for more information) */
void testsync ( double *out , unsigned dimension , const double *in )
{
  out[0] = -K1 * in[0] + K1 *in[1] + pow(in[0],3) ;
  out[1] = K1 * in[0] - (K1 + K2) * in[1] + K2 * in[2] + pow(in[1],4) ;
  out[2] = K2 * in[1] -K2 * in[2] + pow(in[2],2) ;
}

void testsync2 ( double *out , unsigned dimension , const double *in )
{
  out[0] = -K1 * in[0] + K1 * in[1] - pow(in[0],1) - cos(in[3]);
  out[1] = K1 * in[0] - (K1 + K2) * in[1] + K2 * in[2] - pow(in[1],1) ;
  out[2] = K2 * in[1] -K2 * in[2] - pow(in[2],1) ;
  out[3] = 1 ;
}


int main(int argc , char **argv)
{
  unsigned long nsteps = atol(argv[1]) ; /* the number of iterations of the algorithm */ 
  double tj = atof(argv[2]) ;           /* the time gap between consecutive points of the orbit */

  unsigned dimension = 4 ;          
  char *filename = "testesync.dat" ;
  
  double initial[4] = {1 , 1 , 1 , 0 } ; /* the initial conditions for our problem */

  NDorbit *orbita = run_RungeKutta( nsteps , dimension , initial , tj , testsync2 ) ;
  NDorbit_fprint( filename , orbita ) ;

  NDorbit_free(orbita) ;

  return 0 ;
}
