/*
 * AUTHOR: Gonçalo Morais (gnrm@fct.unl.pt) 
 *
 * Version :: 0.0.07 
 * STATE :: Highly Unstable.
 *
 * NUMDE is a scientific
 * library and pretends to implement the state-of-art of the
 * algorithms related with Differential Equations.  Although this
 * project is mainly written by one person, it received the valuable
 * contribution of several people. See the home page of the project
 * for further details.
 */

/*
 *  This file is part of NUMDE.
 *
 *  NUMDE is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  NUMDE is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with NUMDE.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef _NUMDE_POVRAY_H__
#define _NUMDE_POVRAY_H__

#include "numde.h"

/* Next section are the prototypes of functions related with POVRAY */
void NDpovInclude (FILE *out,char *pack) ;
void NDpovAddCamera(FILE *out, TDvector pos, TDvector look, TDvector rot) ;
void NDpovAddAreaLS(FILE *out, TDvector dir, Color color) ;
void NDpovSphereOrbit(FILE *out, NDorbit *in, double radius , char *texture ) ;
void NDpovSky ( FILE *out , double *scale ) ;

void NDpovmesh2 ( FILE *outfile , NDtmesh *mesh ) ;
void NDpovsmesh2 ( FILE *outfile , NDstmesh *mesh ) ;

#endif 
