#include <stdio.h>
#include <stdlib.h>

#include "numde.h"  
#include "numde_povray.h"

#define pi M_PI /* a more conventional name for \pi */ 

void Trifoil( double *coord , double theta )
{
  coord[0] = 41*cos(theta) - 18* sin(theta) - 83*cos(2*theta) - 83*sin(2*theta) - 11*cos(3*theta) + 27*sin(3*theta) ;
  coord[1] = 36*cos(theta) + 27*sin(theta) - 113*cos(2*theta) + 30*sin(2*theta) + 11*cos(3*theta) - 27*sin(3*theta) ;
  coord[2] = 45*sin(theta) - 30*cos(2*theta) + 113*sin(2*theta) - 11*cos(3*theta) + 27*sin(3*theta) ;
}

void dTrifoil( double *coord , double theta )
{
  coord[0] = -41*sin(theta) - 18* cos(theta) + 166*sin(2*theta) - 166*cos(2*theta) + 33*sin(3*theta) + 81*cos(3*theta) ;
  coord[1] = -36*sin(theta) + 27*cos(theta) + 226*sin(2*theta) + 60*cos(2*theta) - 33*sin(3*theta) - 81*cos(3*theta) ;
  coord[2] = 45*cos(theta) + 60*sin(2*theta) + 226*cos(2*theta) + 33*sin(3*theta) + 81*cos(3*theta) ;
}


/* this is a local function */
void NDpovDefinitions ( FILE *out ){
  fprintf(out, 
	  "global_settings { ambient_light rgb<1,1,1> }\n"
      	  );
}


int main ( int argc , char **argv )
{
  unsigned dimension = 3 ;
  unsigned long ncent = 100 ;
  unsigned long nr = 50 ;
  
  /* just an array to keep the values of the coordinates. */
  double *coordp = calloc( dimension , sizeof(double)) ;

  NDorbit *centers = NDorbit_alloc ( ncent , dimension ) ; 
  
  double *theta = calloc ( centers->number , sizeof(double) ) ;
  double scale = 20.0 ;

  unsigned i ;
  for ( i = 0 ; i < centers->number ; i++ ){
    theta[i] = 2 * pi * i / (centers->number - 1.0) ;
    Trifoil( coordp , theta[i] ) ;
    centers->mem[i*dimension + 0] = coordp[0]/(scale+0.0) ;
    centers->mem[i*dimension + 1] = coordp[1]/(scale+0.0) ;    
    centers->mem[i*dimension + 2] = coordp[2]/(scale+0.0) ;
  }

  NDorbit *radius = NDorbit_alloc ( nr , dimension ) ; 
  radius->mem[0] = 1 ;
  rotation_into_NDorbit( radius , 2*pi/(nr + 0.0) , 0 , 1 ) ;
 
  NDstmesh *tube = NDTestSumP( centers , radius , theta , dTrifoil ) ; 


  FILE *outfile ;
  outfile = fopen( "teste.pov" , "w" ) ;
  
  /* begin pov definitions */
  NDpovInclude( outfile, "colors.inc" );
  NDpovInclude( outfile, "textures.inc" );
  NDpovDefinitions( outfile ) ;

  TDvector position = {20,0,0} ;
  TDvector look = {0,1,0} ;
  TDvector rotation = {0,0,0} ;
  NDpovAddCamera( outfile , position , look , rotation ) ;

  /* just some pov to complete the scene */
  Color lightcolor1 = {1 , 1 , 1 } ;
  TDvector lightloc1 = {0,30,3} ;
  TDvector lightloc2 = {3000,800,300} ;
  NDpovAddAreaLS( outfile , lightloc1 , lightcolor1 ) ;
  NDpovAddAreaLS( outfile , lightloc2 , lightcolor1 ) ;
  
  NDpovsmesh2( outfile , tube ) ;

  fclose(outfile) ;
  
  /* we do not need it anymore */
  NDorbit_free(centers) ;
  NDorbit_free(radius) ; 

  NDstmesh_free(tube) ;
  
  return 0 ;

}
