#include <stdio.h>
#include <stdlib.h>

#include "numde.h"  
#include "numde_povray.h"

/* this is a local function */
void povray_Definitions ( FILE *out ){
  fprintf(out, 
	  "global_settings { ambient_light rgb<1, .3, 0> }\n"
      	  );
}


int main ( int argc , char **argv )
{
  unsigned long int steps = atol(argv[1]) ;
  double tj = atof(argv[2]) ;

  unsigned int pdim = 3 ;
  double *initial ;
  initial = calloc ( pdim , sizeof(double)) ;
  initial[0] = 1 ;

  FILE *outfile ;
  outfile = fopen( "lorenz.pov" , "w" ) ;

  /* The header file for lorenz.pov */
  NDpovInclude( outfile, "colors.inc" );
  NDpovInclude( outfile, "functions.inc" );
  NDpovInclude( outfile, "stars.inc" );
  NDpovInclude( outfile, "textures.inc" );
  NDpovInclude( outfile, "woods.inc" );
  
  povray_Definitions( outfile ) ;

  fprintf(outfile,
	  "sky_sphere {\n"
	  "pigment {\n"
	  "gradient <1,1,1>\n"
	  "color_map {\n"
	  "[ 0.0 color rgb <0.99, 0.99, 1> ]\n"
	  "[ 1.0 color rgb <0.1, 0.1, 0.7> ]\n"
	  "}\n"
	  "scale <1, 2, 1>\n"
	  "}\n"
	  "}\n"
 	  );


  TDvector position = {0,0,2} ;
  TDvector look = {0,0,10} ;
  TDvector rotation = {0,-10,-90} ;

  NDpovAddCamera( outfile , position , look , rotation ) ;

  NDorbit *teste = run_RungeKutta ( steps , pdim , initial  , tj , CLorenz ) ;
  NDorbit *cut_teste = NDorbit_cut ( teste , 1 ) ;
  NDorbit_free( teste ) ;

  char *texture = "T_Wood1 scale 2" ;

  NDpovSphereOrbit( outfile , cut_teste , 5*tj , texture ) ;

  Color testea = {.76 , .62 , .34 } ;
  Color testeb = {.99 , .99 , .80 } ;
  TDvector tdir = {34,29,-16} ;
  TDvector tdi = {34,-10,-3} ; 
  NDpovAddAreaLS( outfile , tdir , testea ) ;
  NDpovAddAreaLS( outfile , tdi  , testeb ) ;

  NDorbit_free( cut_teste ) ;
  fclose(outfile) ;
  
  return 0 ;

}
