#include <stdio.h>
#include <stdlib.h>

#include "numde.h"
#include "numde_matrix.h"
#include "numde_povray.h"

#define pi M_PI 

/* this is a local function */
void povray_Definitions ( FILE *out ){
  fprintf(out, 
	  "global_settings { ambient_light rgb<1,1,1> }\n"
      	  );
}

void funct( double *position , double *out )
{
  out[0] = -position[1] ;
  out[1] = position[0] ;
  out[2] = position[2] ;
}




int main( int argc , char **argv )
{
  unsigned dimension = 3 ;
  unsigned long ncent = 200 ;
  unsigned long nr = 200 ;
  
  NDorbit *centers = NDorbit_alloc ( ncent , dimension ) ; 
  
  double theta ;
  double radius = 2 ;
  unsigned i ;
  
  for ( i = 0 ; i < centers->number ; i++ ){
    theta = 2 * pi * i / (centers->number + 0.0) ;
    centers->mem[i*dimension + 0] = radius * cos(theta) ;
    centers->mem[i*dimension + 1] = radius * sin(theta) ;
  }

  NDorbit *circles = NDorbit_alloc ( nr , dimension ) ; 
  circles->mem[0] = 1 ;
  rotation_into_NDorbit( circles , 2*pi/(nr + 0.0) , 0 , 1 ) ;
 
  stubular_NDmesh *tube = NDTestSum( centers , circles , funct ) ; 

  FILE *outfile ;
  outfile = fopen( "teste.pov" , "w" ) ;
  
  /* begin povray definitions */
  povray_Include( outfile, "colors.inc" );
  povray_Include( outfile, "textures.inc" );
  povray_Definitions( outfile ) ;

  TDvector position = {5,0,5} ;
  TDvector look = {0,0,0} ;
  TDvector rotation = {0,0,0} ;
  povray_add_Camera( outfile , position , look , rotation ) ;

  /* just some povray to complete the scene */
  Color lightcolor1 = {1 , 1 , 1 } ;
  TDvector lightloc1 = {0,30,3} ;
  TDvector lightloc2 = {3000,800,300} ;
  povray_add_AreaLS( outfile , lightloc1 , lightcolor1 ) ;
  povray_add_AreaLS( outfile , lightloc2 , lightcolor1 ) ;
  
  povray_smesh2( outfile , tube ) ;
  
  NDorbit_free(centers) ;
  NDorbit_free(circles) ;
  stubular_NDmesh_free(tube) ;

  return 0 ;
}
