#include <stdio.h>
#include <stdlib.h>

#include "numde.h"  
#include "numde_matrix.h"
#include "numde_povray.h"

#define pi M_PI /* a more conventional name for \pi */ 

/* this is a local function */
void povray_Definitions ( FILE *out ){
  fprintf(out, 
	  "global_settings { ambient_light rgb<1,1,1> }\n"
      	  );
}


int main ( int argc , char **argv )
{
  unsigned dimension = 3 ;
  unsigned long ncent = 200 ;
  unsigned long nr = 100 ;
  
  NDorbit *centers = NDorbit_alloc ( ncent , dimension ) ; 
  
  double theta ;
  double escala = 20.0 ;

  unsigned i ;
  for ( i = 0 ; i < centers->number ; i++ ){
    theta = 2 * pi * i / (centers->number - 1.0) ;
    centers->mem[i*dimension + 0] = 
      (41*cos(theta) - 18* sin(theta) - 83*cos(2*theta) - 83*sin(2*theta) - 11*cos(3*theta) + 27*sin(3*theta))/escala ;
    centers->mem[i*dimension + 1] = 
      (36*cos(theta) + 27*sin(theta) - 113*cos(2*theta) + 30*sin(2*theta) + 11*cos(3*theta) - 27*sin(3*theta))/escala ;
    centers->mem[i*dimension + 2] = 
      (45*sin(theta) - 30*cos(2*theta) + 113*sin(2*theta) - 11*cos(3*theta) + 27*sin(3*theta))/escala ;
  }

  NDorbit *radius = NDorbit_alloc ( nr , dimension ) ; 
  radius->mem[0] = 1 ;
  rotation_into_NDorbit( radius , 2*pi/(nr + 0.0) , 0 , 1 ) ;
 
  stubular_NDmesh *tube = NDclosed_scombinatoric_sum( radius , centers ) ; 

  FILE *outfile ;
  outfile = fopen( "teste.pov" , "w" ) ;
  
  /* begin povray definitions */
  povray_Include( outfile, "colors.inc" );
  povray_Include( outfile, "textures.inc" );
  povray_Definitions( outfile ) ;

  TDvector position = {20,0,0} ;
  TDvector look = {0,1,0} ;
  TDvector rotation = {0,0,0} ;
  povray_add_Camera( outfile , position , look , rotation ) ;

  /* just some povray to complete the scene */
  Color lightcolor1 = {1 , 1 , 1 } ;
  TDvector lightloc1 = {0,30,3} ;
  TDvector lightloc2 = {3000,800,300} ;
  povray_add_AreaLS( outfile , lightloc1 , lightcolor1 ) ;
  povray_add_AreaLS( outfile , lightloc2 , lightcolor1 ) ;
  
  povray_smesh2( outfile , tube ) ;

  
  /* we do not need it anymore */
  NDorbit_free(centers) ;
  NDorbit_free(radius) ;

  stubular_NDmesh_free(tube) ;
  fclose(outfile) ;
  
  return 0 ;

}
