/*
 * AUTHOR: Gonçalo Morais (gnrm@fct.unl.pt) 
 *
 * Version :: 0.0.07 
 * STATE :: Highly Unstable.
 *
 * NUMDE is a scientific
 * library and pretends to implement the state-of-art of the
 * algorithms related with Differential Equations.  Although this
 * project is mainly written by one person, it received the valuable
 * contribution of several people. See the home page of the project
 * for further details.
 */

/*
 *  This file is part of NUMDE.
 *
 *  NUMDE is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  NUMDE is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with NUMDE.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef _NUMDE_MATRIX_H__
#define _NUMDE_MATRIX_H__

#include <stdlib.h>
#include <math.h>

#include "numde.h"

typedef struct {
  unsigned rows;
  unsigned cols;
  double *mem;
} Matrix;

Matrix* mat_alloc(unsigned rows, unsigned cols) ;
void mat_free(Matrix *mat) ;

Matrix* mat_read_from_file(const char *filename) ;
int mat_write_into_file(const char *filename, const Matrix *mat) ;

Matrix* mat_multiply(Matrix *a, Matrix *b) ;

Matrix* mat_rotation ( unsigned dimension , double angle , unsigned coord_a , unsigned coord_b ) ;
void rotation_into_NDorbit ( NDorbit *orb , double angle , unsigned coord_a , unsigned coor_b ) ;
void mat_NDorbit ( NDorbit *orb , Matrix *matrix ) ;

#endif
