#include <stdio.h>
#include <stdlib.h>

#include "numde.h"

#define K1 1
#define K2 1 


/* the vector field that is used in the computations (see numde.h, for more information) */
void testsync ( double *out , unsigned dimension , const double *in )
{
  out[0] = -K1 * in[0] + K1 *in[1] + 20*cos(in[0]) + pow(in[0],3) ;
  out[1] = K1 * in[0] - (K1 + K2) * in[1] + K2 * in[2] + 30*cos(in[1]) + pow(in[1],4) ;
  out[2] = K2 * in[1] -K2 * in[2] + 20*cos(in[2]) ;
}


int main(int argc , char **argv)
{
  unsigned long nsteps = atol(argv[1]) ; /* the number of iterations of the algorithm */ 
  double tj = atof(argv[2]) ;           /* the time gap between consecutive points of the orbit */

  unsigned dimension = 3 ;          
  char *filename = "testesync.dat" ;
  
  double initial[3] = {.2 , -1.5 , -3 } ; /* the initial conditions for our problem */

  NDorbit *orbita = run_RungeKutta( nsteps , dimension , initial , tj , testsync ) ;
  
  NDorbit_fprint( filename , orbita ) ;

  NDorbit_free(orbita) ;

  return 0 ;
}
