#include <stdio.h>
#include <stdlib.h>

#include "numde.h"  
#include "numde_matrix.h"

#define pi M_PI  /* definition of PI in math.h */

/* this is a local function */
void povray_Definitions ( FILE *out ){
  fprintf(out, 
	  "global_settings { ambient_light rgb<1, .3, 0> }\n"
      	  );
}


int main ( int argc , char **argv )
{
  FILE *outfile ;
  outfile = fopen("demo.pov" , "w") ;

  /* begin povray definitions */
  povray_Include( outfile, "colors.inc" );
  povray_Include( outfile, "functions.inc" );
  povray_Include( outfile, "stars.inc" );
  povray_Include( outfile, "textures.inc" );
  povray_Include( outfile, "woods.inc" );
  povray_Definitions(outfile) ;

/*   double scale[3] = { 2 , 1 , 1 } ; */
/*   povray_Sky( outfile , scale ) ; */
  
  char *texture = "T_Wood30 scale .5" ;

  TDvector position = {2,0,-4} ;
  TDvector look = {0,0,10} ;
  TDvector rotation = {0,0,0} ;
  povray_add_Camera( outfile , position , look , rotation ) ;
  /* end povray definitions */
  

  unsigned dimension = 3 ;
  /* */
  unsigned long nelements = 40 ; 
  NDorbit *orbita = NDorbit_alloc( nelements , dimension );

  orbita->mem[0] = 5 ;
  rotation_into_NDorbit ( orbita , pi / 20. , 0 , 1 ) ;
  
  unsigned long celements = 600 ;
  NDorbit *centers = NDorbit_alloc( celements , dimension ) ;
  

  unsigned long i ;
  
  for ( i = 0 ; i < celements ; i++ )
    centers->mem[i*centers->dim + 2] = 1*i ;
  
  NDorbit *tube = NDorbit_combinatoric_sum( orbita , centers ) ;
  povray_NDorbit_sphere( outfile , tube , .34 , texture ) ; 


  /* just some povray to complete the scene */
  Color testea = {.76 , .62 , .34 } ;
  Color testeb = {.99 , .99 , .80 } ;
  TDvector tdir = {34,29,-16} ;
  TDvector tdi = {14,-10,-3} ; 
  povray_add_AreaLS( outfile , tdir , testea ) ;
  povray_add_AreaLS( outfile , tdi  , testeb ) ;


  NDorbit_free(tube) ;
  NDorbit_free(centers);
  NDorbit_free(orbita) ;

  fclose(outfile) ;

  return 0 ;

}
