#include <stdio.h>
#include <stdlib.h>

#include "numde.h"  
#include "numde_matrix.h"
#include "numde_povray.h"

#define pi M_PI /* a more conventional name for \pi */ 

/* this is a local function */
void povray_Definitions ( FILE *out ){
  fprintf(out, 
	  "global_settings { ambient_light rgb<1,1,1> }\n"
      	  );
}


int main ( int argc , char **argv )
{
  
  /* the dimension of the problem */ 
  unsigned dimension = 3 ;
    
  /* the radius around the centers */
  unsigned long nradius = 80 ;
  NDorbit *arus = NDorbit_alloc( nradius , dimension ) ;
  
  arus->mem[0] = 1 ; /* the radius of the tube */
  rotation_into_NDorbit ( arus ,2* pi/(nradius+0.0) , 0 , 1 ) ;

  /* the centers of the tube that we want to copute the mesh */
  unsigned long ncenters = 1000 ;
  NDorbit *centers = NDorbit_alloc ( ncenters , dimension ) ;
  
  double theta ;
  double escala = 20.0 ;

  unsigned i ;
  for ( i = 0 ; i < ncenters ; i++ ){
    theta = 2 * pi * i / (ncenters - 1.0) ;
    centers->mem[i*dimension + 0] = 
      (41*cos(theta) - 18* sin(theta) - 83*cos(2*theta) - 83*sin(2*theta) - 11*cos(3*theta) + 27*sin(3*theta))/escala ;
    centers->mem[i*dimension + 1] = 
      (36*cos(theta) + 27*sin(theta) - 113*cos(2*theta) + 30*sin(2*theta) + 11*cos(3*theta) - 27*sin(3*theta))/escala ;
    centers->mem[i*dimension + 2] = 
      (45*sin(theta) - 30*cos(2*theta) + 113*sin(2*theta) - 11*cos(3*theta) + 27*sin(3*theta))/escala ;
  }



  /* Now we create a grid */
  stubular_NDmesh *tube = NDclosed_scombinatoric_sum( arus , centers ) ;

  NDorbit_free(arus) ;
  NDorbit_free(centers) ;

  /* 
   * Now we will just add things to our scene.
   */


  FILE *povray_file ;
  povray_file = fopen("teste.pov" , "w" ) ;

  /* begin povray definitions */
  povray_Include( povray_file, "colors.inc" );
  povray_Include( povray_file, "functions.inc" );
  povray_Include( povray_file, "stars.inc" );
  povray_Include( povray_file, "textures.inc" );
  povray_Include( povray_file, "woods.inc" );
  povray_Include( povray_file, "metals.inc" );
  povray_Definitions(povray_file) ;

/*    double scale[3] = { 2 , 1 , 1 } ; */
/*    povray_Sky( povray_file , scale ) ; */
  
/*  char *texture = "T_Wood30 scale .5" ;*/

  TDvector position = {2,0,-21} ;
  TDvector look = {0,0,2} ;
  TDvector rotation = {0,0,0} ;
  povray_add_Camera( povray_file , position , look , rotation ) ;
  /* end povray definitions */

  povray_smesh2 ( povray_file , tube ) ; 
  

  /* just some povray to complete the scene */
  Color testea = {.76 , .62 , .34 } ;
  Color testeb = {.99 , .99 , .80 } ;
  
  TDvector tdir = {34,29,-16} ;
  TDvector tdi = {14,-10,-3} ;

  povray_add_AreaLS( povray_file , tdir , testea ) ;
  povray_add_AreaLS( povray_file , tdi  , testeb ) ;

  fprintf( povray_file ,
	   "light_source\n"
	   "   { <0,0,0> color 1\n"
	   "     looks_like\n"
	   "       { sphere\n"
	   "         { <0,0,0>,10\n"
	   "           color  rgb 1 \n"
	   "           finish { ambient 1 }\n"
	   "         }\n"
	   "       }\n"
	   "     translate <10,20,30>\n"
	   "     }\n") ;

  fclose( povray_file ) ;
  stubular_NDmesh_free(tube) ;

  return 0 ;

}
