#include <stdio.h>
#include <stdlib.h>

#include "numde.h"  

/* this is a local function */
void povray_Definitions ( FILE *out ){
  fprintf(out, 
	  "global_settings { ambient_light rgb<1, .3, 0> }\n"
      	  );
}


int main ( int argc , char **argv )
{
  unsigned long int steps = atol(argv[1]) ;
  double tj = atof(argv[2]) ;

  unsigned int pdim = 3 ;
  double *initial ;
  initial = calloc ( pdim , sizeof(double)) ;
  initial[0] = 1 ;
  initial[1] = 2 ;

  FILE *outfile ;
  outfile = fopen( "demo.pov" , "w" ) ;

  /* The header file for lorenz.pov */
  povray_Include( outfile, "colors.inc" );
  povray_Include( outfile, "functions.inc" );
  povray_Include( outfile, "stars.inc" );
  povray_Include( outfile, "textures.inc" );
  povray_Include( outfile, "woods.inc" );
  
  povray_Definitions( outfile ) ;

  fprintf(outfile,
	  "sky_sphere {\n"
	  "pigment {\n"
	  "gradient <1,1,1>\n"
	  "color_map {\n"
	  "[ 0.0 color rgb <0.99, 0.99, 1> ]\n"
	  "[ 1.0 color rgb <0.1, 0.1, 0.7> ]\n"
	  "}\n"
	  "scale <5, 2, 1>\n"
	  "}\n"
	  "}\n"
 	  );


  _3DVector position = {7,2,-15} ;
  _3DVector look = {0,0,10} ;
  _3DVector rotation = {180,0,0} ;

  povray_add_Camera( outfile , position , look , rotation ) ;

  NDorbit *teste = run_RungeKutta ( steps , pdim , initial  , tj , Rossler ) ;

  NDorbit *cut_teste = NDorbit_cut ( teste , 3 ) ;
  NDorbit_free( teste ) ;

  povray_NDorbit_sphere( outfile , cut_teste , 5*tj ) ;

  Color testea = {.76 , .62 , .34 } ;
  Color testeb = {.99 , .99 , .80 } ;
  
  _3DVector tdir = {0,0,-30} ;
  _3DVector tdi = {0,0,30} ; 
  
  povray_add_AreaLS( outfile , tdir , testea ) ;
  povray_add_AreaLS( outfile , tdi , testeb ) ;

  NDorbit_free( cut_teste ) ;

  fclose(outfile) ;
  
  return 0 ;

}
